﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private rand As New Random()
    Private numTaps As Integer = 0
    Private appService As PhoneApplicationService = PhoneApplicationService.Current


    Public Sub New()
        InitializeComponent()
        UpdatePageTitle(numTaps)

        ' Access App class for isolated storage setting
        Dim brush = (TryCast(Application.Current, App)).BackgroundBrush

        If brush IsNot Nothing Then
            ContentPanel.Background = brush
        End If
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        Dim brush As New SolidColorBrush(Color.FromArgb(255, CByte(rand.Next(256)),
                                                             CByte(rand.Next(256)),
                                                             CByte(rand.Next(256))))
        ContentPanel.Background = brush

        ' Save to App class for isolated storage setting
        TryCast(Application.Current, App).BackgroundBrush = brush

        numTaps += 1
        UpdatePageTitle(numTaps)

        args.Complete()
        MyBase.OnManipulationStarted(args)
    End Sub


    Private Sub UpdatePageTitle(ByVal numTaps As Integer)
        PageTitle.Text = String.Format("{0} taps total", numTaps)
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        appService.State("numTaps") = numTaps

        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        ' Load numTaps
        If appService.State.ContainsKey("numTaps") Then
            Int32.TryParse(appService.State("numTaps").ToString(), numTaps)
            UpdatePageTitle(numTaps)
        End If
    End Sub
End Class
